#pragma once

#include "police/action.hpp"
#include "police/storage/vector.hpp"

namespace police::successor_generator {

using ActionId = size_t;
using ApplicableActions = vector<ActionId>;

class ApplicableActionsGenerator {
public:
    explicit ApplicableActionsGenerator(const vector<Action>* actions)
        : actions_(actions)
    {
    }

    template <typename StateType>
    [[nodiscard]]
    ApplicableActions operator()(const StateType& state) const
    {
        auto get_value = [&state](size_t var_id) {
            return static_cast<real_t>(state[var_id]);
        };
        ApplicableActions aops;
        ActionId edge_id = 0;
        for (; edge_id < actions_->size(); ++edge_id) {
            if ((*actions_)[edge_id].guard.evaluate(get_value)) {
                aops.push_back(edge_id);
            }
        }
        return aops;
    }

private:
    const vector<Action>* actions_;
};

} // namespace police::successor_generator
