#pragma once

#include <ranges>

namespace police::successor_generator {

template <typename SuccessorGenerator>
class determinize_outcomes_adapator : public SuccessorGenerator {
public:
    using base_type = SuccessorGenerator;

    explicit determinize_outcomes_adapator(
        SuccessorGenerator successor_generator)
        : SuccessorGenerator(std::move(successor_generator))
    {
    }

    template <typename State>
    [[nodiscard]]
    auto operator()(const State& state)
    {
        auto outcomes = SuccessorGenerator::operator()(state);
        return outcomes | std::ranges::views::join;
    }
};

} // namespace police::successor_generator
