#include "police/successor_generator/successor_generator.hpp"
#include "police/action.hpp"
#include "police/storage/flat_state.hpp"

namespace police::successor_generator {

Successor SuccessorIterator::operator*() const
{
    flat_state successor(*state_);
    for (const Assignment& eff : outcome_->assignments) {
        successor[eff.var_id] = Value(
            eff.value.evaluate([&](size_t var_id) {
                return static_cast<real_t>((*state_)[var_id]);
            }),
            (*state_)[eff.var_id].get_type());
    }
    return Successor(std::move(successor), label_);
}

SuccessorRange OutcomeSuccessorGenerator::operator()(
    std::shared_ptr<FlatState> state,
    size_t action_index) const
{
    const Action& action = (*actions_)[action_index];
    return {
        SuccessorIterator(
            action.outcomes.begin(),
            std::move(state),
            action.label),
        SuccessorIterator(action.outcomes.end(), nullptr, action.label)};
}

} // namespace police::successor_generator
