#pragma once

#include "police/base_types.hpp"

#include <cassert>
#include <cstdint>

namespace police::bits {

constexpr std::uint32_t get_msb(std::uint32_t x)
{
    return 31u - __builtin_clz(x | 1);
}

constexpr std::uint32_t get_lsb(std::uint32_t x)
{
    return __builtin_ctz(x | 1);
}

template <typename Block>
constexpr Block pattern(size_t width, size_t offset = 0)
{
    assert(offset + width <= sizeof(Block) * 8);
    assert(width != 0);
    return width == sizeof(Block) * 8
               ? ~Block(0)
               : ~(~static_cast<Block>(0) << static_cast<Block>(width))
                     << static_cast<Block>(offset);
}

template <typename Block>
constexpr Block mix(Block a, Block b, size_t width)
{
    return (a << static_cast<Block>(width)) | (b & pattern<Block>(width));
}

} // namespace police::bits
