#pragma once

#include <ostream>
#include <ranges>

namespace police {

template <std::ranges::range R>
class print_sequence {
public:
    explicit print_sequence(R r)
        : r(std::move(r))
    {
    }

    template <typename Iterator, typename Sentinel>
    print_sequence(Iterator first, Sentinel last)
        : r(std::ranges::subrange(first, last))
    {
    }

    R r;
};

template <typename Iterator, typename Sentinel>
print_sequence(Iterator, Sentinel)
    -> print_sequence<std::ranges::subrange<Iterator, Sentinel>>;

template <std::ranges::range R>
std::ostream& operator<<(std::ostream& out, police::print_sequence<R> seq)
{
    out << "[";
    bool sep = false;
    for (auto it = seq.r.begin(); it != seq.r.end(); ++it) {
        out << (sep ? ", " : "") << (*it);
        sep = true;
    }
    out << "]";
    return out;
}

template <std::ranges::range R, typename P>
class generic_print_sequence {
public:
    explicit generic_print_sequence(R r, P p)
        : r(std::move(r))
        , p(std::move(p))
    {
    }

    R r;
    P p;
};

template <std::ranges::range R, typename P>
std::ostream&
operator<<(std::ostream& out, police::generic_print_sequence<R, P> seq)
{
    out << "[";
    bool sep = false;
    for (auto it = seq.r.begin(); it != seq.r.end(); ++it) {
        out << (sep ? ", " : "");
        seq.p(out, *it);
        sep = true;
    }
    out << "]";
    return out;
}

} // namespace police
