#pragma once

#include "police/base_types.hpp"

#include <algorithm>
#include <memory>
#include <random>

namespace police {

class RNG {
public:
    explicit RNG(int_t seed);

    /**
     * Samples a number from the interval [0, 1] uniform at random.
     **/
    real_t operator()() const;

    /**
     * Samples an integer from the interval [a, b] uniform at random.
     **/
    int_t operator()(int_t a, int_t b) const;

    /**
     * Samples an integer from the interval [0, n) uniform at random.
     **/
    size_t operator()(size_t last) const;

    template <typename Iterator>
    void shuffle(Iterator first, Iterator last) const
    {
        std::shuffle(first, last, *gen_);
    }

private:
    std::shared_ptr<std::mt19937_64> gen_;
};

} // namespace police
