#pragma once

#include "police/storage/variable_space.hpp"

#include <ostream>

namespace police {

template <typename Range>
struct value_range_printer {
public:
    explicit value_range_printer(
        const VariableSpace& vspace,
        const Range& values)
        : vspace_(vspace)
        , values_(values)
    {
    }

    friend std::ostream&
    operator<<(std::ostream& out, const value_range_printer& p)
    {
        out << "{";
        bool first = true;
        for (const auto& [var, val] : p.values_) {
            out << (!first ? ", " : "") << p.vspace_.get_name(var) << "="
                << val;
            first = false;
        }
        out << "}";
        return out;
    }

private:
    const VariableSpace& vspace_;
    const Range& values_;
};

template <typename Vector>
struct value_vector_printer {
public:
    explicit value_vector_printer(
        const VariableSpace& vspace,
        const Vector& values)
        : vspace_(vspace)
        , values_(values)
    {
    }

    friend std::ostream&
    operator<<(std::ostream& out, const value_vector_printer& p)
    {
        out << "{";
        for (size_t var = 0; var < p.vspace_.size(); ++var) {
            out << (var > 0 ? ", " : "") << p.vspace_.get_name(var) << "="
                << p.values_[var];
        }
        out << "}";
        return out;
    }

private:
    const VariableSpace& vspace_;
    const Vector& values_;
};

} // namespace police
