#include "police/var_order_conditions.hpp"

#include "police/arguments.hpp"
#include "police/model.hpp"
#include "police/option.hpp"

#include <limits>

namespace police {

ConditionNumberVariableOrdering::ConditionNumberVariableOrdering(
    const Model& model)
{
    vector<size_t> num(
        model.variables.size(),
        std::numeric_limits<size_t>::max());
    for (const auto& action : model.actions) {
        for (const auto& constraint : action.guard) {
            for (const auto& [var, coef] : constraint) {
                --num[var];
            }
        }
    }
    set_variable_ranks(std::move(num));
}

namespace {

PointerOption<VariableOrderChooser>
    _option("condition_number", [](const Arguments& args) {
        return std::make_shared<ConditionNumberVariableOrdering>(
            args.get_model());
    });

} // namespace

} // namespace police
