#include "police/var_order_default.hpp"

#include "police/arguments.hpp"
#include "police/model.hpp"
#include "police/option.hpp"

#include <numeric>

namespace police {

DefaultVariableOrder::DefaultVariableOrder(size_t num_vars)
{
    vector<size_t> ranks(num_vars);
    std::iota(ranks.begin(), ranks.end(), 0);
    set_variable_ranks(std::move(ranks));
}

namespace {

PointerOption<VariableOrderChooser>
    _option("default", [](const Arguments& args) {
        return std::make_shared<DefaultVariableOrder>(
            args.get_model().variables.size());
    });

} // namespace

} // namespace police
