#include "police/var_order_reverse.hpp"

#include "police/option.hpp"
#include "police/option_parser.hpp"

#include <limits>

namespace police {

VariableOrderReverser::VariableOrderReverser(
    std::shared_ptr<VariableOrderChooser> chooser)
{
    vector<size_t> ranks = chooser->get_variable_ranks();
    for (size_t i = 0; i < ranks.size(); ++i) {
        ranks[i] = std::numeric_limits<size_t>::max() - ranks[i];
    }
    set_variable_ranks(std::move(ranks));
}

namespace {

PointerOption<VariableOrderChooser> _option(
    "reverse",
    [](const Arguments& args) {
        return std::make_shared<VariableOrderReverser>(
            args.get_ptr<VariableOrderChooser>("order"));
    },
    [](ArgumentsDefinition& defs) {
        defs.add_ptr_argument<VariableOrderChooser>("order");
    });

} // namespace

} // namespace police
