#include "police/verifiers/ic3/sat_based/goal_checker.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/variable.hpp"
#include "police/smt.hpp"
#include "police/verifiers/ic3/cube.hpp"

namespace police::ic3 {

GoalChecker::GoalChecker(std::shared_ptr<SMT> goal)
    : goal_(std::move(goal))
{
}

namespace {

expressions::Expression ase(size_t var, const police::ic3::Interval& i)
{
    expressions::Variable v(var);
    if (i.lb == i.ub) {
        return expressions::equal(v, i.lb);
    } else {
        return expressions::greater_equal(v, i.lb) &&
               expressions::less_equal(v, i.ub);
    }
}

expressions::Expression ase(const police::ic3::Cube& c)
{
    assert(!c.empty());
    auto it = c.begin();
    expressions::Expression r = ase(it->first, it->second);
    ++it;
    for (; it != c.end(); ++it) {
        r = r && ase(it->first, it->second);
    }
    return r;
}

} // namespace

bool GoalChecker::operator()(const police::ic3::Cube& cube) const
{
    goal_->push_snapshot();
    goal_->add_constraint(ase(cube));
    const auto result = goal_->solve();
    goal_->pop_snapshot();
    return result == SMT::Status::SAT;
}

} // namespace police::ic3
