#pragma once

#include "police/nnlp_factory.hpp"
#include "police/smt_factory.hpp"
#include "police/verifiers/ic3/cube.hpp"
#include "police/verifiers/ic3/sat_based/ic3_engine.hpp"
#include "police/verifiers/ic3/sat_based/ic3_sat.hpp"
#include "police/verifiers/ic3/sat_based/sat_interface/nnlp.hpp"

#include <memory>

namespace police::ic3 {

struct PIC3SatSingletonParameters {
    std::shared_ptr<SMTFactory> smt;
    std::shared_ptr<NNLPFactory> nnlp;
    bool app_filter;
    bool non_policy_prefilter;
};

struct SingletonSatOption final : public SatInterfaceOption {
    explicit SingletonSatOption(PIC3SatSingletonParameters params)
        : params(std::move(params))
    {
    }

    [[nodiscard]]
    Kind kind() const
    {
        return SINGLETON;
    }

    PIC3SatSingletonParameters params;
};

class PIC3SatSingleton {
public:
    PIC3SatSingleton(
        const PIC3SatSingletonParameters& params,
        const Model& model,
        const NeuralNetworkPolicy& policy,
        const vector<LinearConstraintDisjunction>& not_terminal,
        const LinearCondition& goal);

    std::pair<bool, size_t> is_blocked(const ic3::Cube& cube, size_t frame);

    void set_blocked(const ic3::Cube& cube, size_t frame);

    void clear_frames();

    void add_frame();

    void dump(std::ostream& out) const;

    ic3::Cube get_unsat_core() const;

private:
    std::shared_ptr<NNLP> lp_;
    std::shared_ptr<IC3SatInterface> silent_ = nullptr;
    std::shared_ptr<ic3::SatInterfaceNNLP> policy_ = nullptr;
    std::shared_ptr<IC3SatInterface> non_policy_prefilter_ = nullptr;
    bool prefiltered_ = false;
};

} // namespace police::ic3
