#pragma once

#include "police/base_types.hpp"
#include "police/lp.hpp"
#include "police/storage/vector.hpp"
#include "police/verifiers/ic3/concepts.hpp"
#include "police/verifiers/ic3/cube.hpp"

namespace police::ic3 {

class SatInterfaceLP {
public:
    SatInterfaceLP(
        LP* base_lp,
        vector<size_t> in_vars,
        vector<size_t> out_vars);

    std::pair<bool, size_t> is_blocked(const Cube& cube, size_t frame_id) const;

    void set_blocked(const Cube& cube, size_t frame_id);

    void add_frame();

    void clear_frames();

private:
    vector<size_t> input_vars_;
    vector<size_t> output_vars_;
    size_t frame_var_;
    LP* lp_;
};

static_assert(concepts::SatInterface<SatInterfaceLP>);

} // namespace police::ic3
