#pragma once

#include "police/base_types.hpp"
#include "police/storage/vector.hpp"
#include "police/verifiers/ic3/concepts.hpp"
#include "police/verifiers/ic3/cube.hpp"

namespace police {
class NNLP;
}

namespace police::ic3 {

class SatInterfaceNNLP {
public:
    SatInterfaceNNLP(
        NNLP* base_lp,
        size_t frame_var,
        vector<size_t> input_vars,
        vector<size_t> output_vars);

    [[nodiscard]]
    std::pair<bool, size_t> is_blocked(const Cube& cube, size_t frame_id);

    void set_blocked(const Cube& cube, size_t frame_id);

    void add_frame();

    void clear_frames();

    [[nodiscard]]
    const NNLP* get_lp() const
    {
        return lp_;
    }

    const Cube& get_unsat_core() const
    {
        assert(supports_unsat_core());
        return unsat_core_;
    }

    bool supports_unsat_core() const;

private:
    bool is_blocked_by_frame(const Cube& cube, size_t frame_id);

    vector<size_t> input_vars_;
    vector<size_t> output_vars_;
    vector<size_t> var_refs_;
    Cube unsat_core_;
    NNLP* lp_;
    size_t frame_var_;
    size_t unsolvable_frame_;
};

static_assert(concepts::SatInterface<SatInterfaceNNLP>);

} // namespace police::ic3
