#pragma once

#include "police/base_types.hpp"
#include "police/smt.hpp"
#include "police/storage/vector.hpp"
#include "police/verifiers/ic3/concepts.hpp"
#include "police/verifiers/ic3/cube.hpp"

namespace police::ic3 {

class SatInterfaceSMT {
public:
    SatInterfaceSMT(
        SMT* base_smt,
        vector<size_t> in_vars,
        vector<size_t> out_vars);

    std::pair<bool, size_t> is_blocked(const Cube& cube, size_t frame_id);

    void set_blocked(const Cube& cube, size_t frame_id);

    void add_frame();

    void clear_frames();

    const Cube& get_unsat_core() const { return unsat_core_; }

protected:
    SatInterfaceSMT(
        SMT* base_smt,
        size_t frame_var,
        vector<size_t> in_vars,
        vector<size_t> out_vars);

    vector<size_t> input_vars_;
    vector<size_t> output_vars_;
    vector<size_t> smt_var_refs_;
    Cube unsat_core_;
    size_t frame_var_;
    size_t unsolvable_frame_;
    SMT* smt_;
};

static_assert(concepts::SatInterface<SatInterfaceSMT>);

} // namespace police::ic3
