#pragma once

#include "police/smt.hpp"
#include "police/storage/flat_state.hpp"
#include "police/verifiers/ic3/concepts.hpp"
#include "police/verifiers/ic3/cube.hpp"

namespace police::ic3 {

class StartGenerator {
public:
    StartGenerator(
        size_t num_vars,
        std::shared_ptr<SMT> base_smt,
        vector<std::pair<size_t, Value>> aux_values = {});

    [[nodiscard]]
    std::optional<flat_state> operator()() const;

    void set_blocked(const Cube& cube);

    void clear();

private:
    std::shared_ptr<SMT> smt_;
    vector<std::pair<size_t, Value>> aux_values_;
    size_t num_vars_;
};

static_assert(concepts::StartStateGenerator<StartGenerator>);

} // namespace police::ic3
