#include "police/verifiers/ic3/statistics.hpp"

namespace police::ic3 {

Statistics::Statistics()
    : total_time(false)
    , frame_construction_time(false)
    , refinement_time(false)
    , start_generation_time(false)
{
}

void Statistics::print_status_line(std::ostream& out) const
{
    out << "ic3: frames=" << frames << " obl=" << obligations
        << " clauses=" << clauses << " t=" << total_time << std::endl;
}

} // namespace police::ic3

namespace police {

std::ostream& operator<<(std::ostream& out, const ic3::Statistics& stats)
{
    out << "Frames: " << stats.frames << "\n";
    out << "Obligations: " << stats.obligations << "\n";
    out << "Rescheduled obligations: " << stats.rescheduled << "\n";
    out << "Clauses: " << stats.clauses << "\n";
    // for (auto i = 0u; i < stats.clauses_per_frame.size(); ++i) {
    //     out << "  " << (i + 1) << ": " << stats.clauses_per_frame[i] << "\n";
    // }
    out << "Path candidates: " << stats.paths << "\n";
    out << "IC3 total time: " << stats.total_time << "\n";
    out << "Frame construction time: " << stats.frame_construction_time << "\n";
    out << "Frame refinement time: " << stats.refinement_time << "\n";
    out << "Start state generation time: " << stats.start_generation_time
        << "\n";
    return out;
}

} // namespace police
