#pragma once

#include "police/verifiers/ic3/syntactic/frames_storage.hpp"

namespace police::ic3::syntactic {

class FramesStorageInitializer {
public:
    explicit FramesStorageInitializer(FramesStorage* frames)
        : frames_(frames)
    {
    }

    void operator()() { frames_->clear(); }

private:
    FramesStorage* frames_;
};

class FramesStorageMemberTest {
public:
    explicit FramesStorageMemberTest(FramesStorage* frames)
        : frames_(frames)
    {
    }

    [[nodiscard]]
    bool operator()(const flat_state& state, size_t frame_idx) const
    {
        const auto [cube_id, cube_frame] =
            frames_->get_frame_rejection_cube(state);
        return cube_frame < frame_idx;
    }

private:
    FramesStorage* frames_;
};

} // namespace police::ic3::syntactic
