#pragma once

#include "police/linear_condition.hpp"
#include "police/storage/flat_state.hpp"
#include "police/verifiers/ic3/syntactic/sufficient_condition.hpp"

namespace police::ic3::syntactic {

class PolicyReasoner {
public:
    virtual SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action) = 0;

    virtual void prepare([[maybe_unused]] const flat_state& state) {}
};

} // namespace police::ic3::syntactic
