#pragma once

#include "police/addtree_policy.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/syntactic/policy_reasoner.hpp"

namespace police::ic3::syntactic {

class PolicyReasonerBoxes final : public PolicyReasoner {
public:
    explicit PolicyReasonerBoxes(
        const AddTreePolicy* policy,
        const VariableSpace* variables);

    static void collect_box_constraints(
        vector<bool>& lbs,
        vector<bool>& ubs,
        const flat_state& state,
        const vector<size_t>& input,
        const AddTree& addtree);

    [[nodiscard]]
    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action) override;

private:
    const AddTreePolicy* policy_;
    [[maybe_unused]]
    const VariableSpace* variables_;
};

} // namespace police::ic3::syntactic
