#include "police/verifiers/ic3/syntactic/policy_reasoner_input.hpp"

#include "police/addtree_policy.hpp"
#include "police/cg_policy.hpp"
#include "police/linear_condition.hpp"
#include "police/macros.hpp"
#include "police/nn_policy.hpp"
#include "police/option.hpp"

namespace police::ic3::syntactic {

PolicyReasonerInput::PolicyReasonerInput(vector<size_t> input_vars)
    : input_vars_(std::move(input_vars))
{
    reason_.reserve(input_vars_.size());
    for (size_t i = 0; i < input_vars_.size(); ++i) {
        reason_.emplace_back(input_vars_[i], VariableCondition::EQUALITY);
    }
}

SuffCondAlternatives PolicyReasonerInput::get_reason(
    const flat_state&,
    const LinearConstraintConjunction&,
    size_t)
{
    return {reason_};
}

namespace {
PointerOption<PolicyReasoner> _opt("input", [](const Arguments& args) {
    if (args.applicability_masking) {
        POLICE_EXIT_INVALID_INPUT(
            "input policy reasoner doesn't support applicability masking");
    }
    if (args.has_addtree_policy()) {
        const AddTreePolicy& policy = args.get_addtree_policy();
        return std::make_shared<PolicyReasonerInput>(policy.get_input());
    } else if (args.has_cg_policy()) {
        const CGPolicy& policy = args.get_cg_policy();
        return std::make_shared<PolicyReasonerInput>(policy.get_input());
    } else if (args.has_nn_policy()) {
        const NeuralNetworkPolicy& policy = args.get_nn_policy();
        return std::make_shared<PolicyReasonerInput>(policy.get_input());
    } else {
        POLICE_RUNTIME_ERROR("no policy defined");
    }
});
} // namespace

} // namespace police::ic3::syntactic
