#pragma once

#include "police/linear_condition.hpp"
#include "police/verifiers/ic3/syntactic/policy_reasoner.hpp"

namespace police::ic3::syntactic {

class PolicyReasonerInput final : public PolicyReasoner {
public:
    explicit PolicyReasonerInput(vector<size_t> input_vars);

    [[nodiscard]]
    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action) override;

private:
    vector<size_t> input_vars_;
    SufficientCondition reason_;
};

} // namespace police::ic3::syntactic
