#pragma once

#include "police/cg_policy.hpp"
#include "police/cg_relaxation.hpp"
#include "police/compute_graph.hpp"
#include "police/linear_condition.hpp"
#include "police/verifiers/ic3/cube.hpp"
#include "police/verifiers/ic3/syntactic/applicability_conditioner.hpp"
#include "police/verifiers/ic3/syntactic/policy_reasoner.hpp"
#include "police/verifiers/ic3/syntactic/sufficient_condition.hpp"
#include "police/verifiers/ic3/syntactic/variable_classification.hpp"

namespace police::ic3::syntactic {

class PolicyReasonerLIPABase : public PolicyReasoner {
public:
    [[nodiscard]]
    bool can_be_selected(const Cube& cube, size_t action);

protected:
    PolicyReasonerLIPABase(
        const Model* model,
        std::shared_ptr<CGPolicy> policy,
        const vector<size_t>& var_order,
        cg::RelaxationOptions options);

    template <bool MaskedApplicable>
    SuffCondAlternatives compute_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action,
        ApplicabilityConditioner* applicable = nullptr);

    vector<size_t> input_;
    vector<size_t> relaxation_vars_;
    vector<std::shared_ptr<cg::ComputeGraphRelaxation>> lipa_;
    vector<std::shared_ptr<cg::LinearLayer>> comparison_layer_;
    vector<VariableCategory> var_class_;
    vector<size_t> label_to_index_;

    const Model* model_;
    std::shared_ptr<CGPolicy> policy_;
};

class PolicyReasonerLIPA final : public PolicyReasonerLIPABase {
public:
    PolicyReasonerLIPA(
        const Model* model,
        std::shared_ptr<CGPolicy> policy,
        const vector<size_t>& var_order,
        cg::RelaxationOptions options)
        : PolicyReasonerLIPABase(
              model,
              std::move(policy),
              var_order,
              std::move(options))
    {
    }

    [[nodiscard]]
    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action) override;
};

class PolicyReasonerLIPAMasked final : public PolicyReasonerLIPABase {
public:
    PolicyReasonerLIPAMasked(
        const Model* model,
        std::shared_ptr<CGPolicy> policy,
        const vector<size_t>& var_order,
        cg::RelaxationOptions options)
        : PolicyReasonerLIPABase(
              model,
              std::move(policy),
              var_order,
              std::move(options))
    {
    }

    void prepare(const flat_state& state) override
    {
        info_ = ApplicabilityInformation(*model_, state);
    }

    [[nodiscard]]
    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action) override;

private:
    ApplicabilityInformation info_;
};

} // namespace police::ic3::syntactic
