#pragma once

#include "police/addtree.hpp"
#include "police/addtree_policy.hpp"
#include "police/model.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/syntactic/applicability_conditioner.hpp"
#include "police/verifiers/ic3/syntactic/policy_reasoner.hpp"
#include "police/verifiers/ic3/syntactic/variable_classification.hpp"

#include <memory>

namespace police::ic3::syntactic {

class PolicyReasonerVeritasBase : public PolicyReasoner {
public:
    PolicyReasonerVeritasBase(
        const Model& model,
        const AddTreePolicy& policy,
        const vector<size_t>& var_order);

protected:
    template <bool ApplicabilityMasked>
    [[nodiscard]]
    SuffCondAlternatives compute_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t label,
        ApplicabilityConditioner* applicability);

private:
    const VariableSpace* variables_;
    std::shared_ptr<AddTree> addtree_;
    vector<size_t> input_features_;
    vector<size_t> class_index_;
    vector<size_t> min_order_;
    vector<VariableCategory> var_class_;
    vector<double> base_scores_;
#ifndef POLICE_NO_STATISTICS
    std::shared_ptr<std::ostream> stats_file_ = nullptr;
#endif
};

class PolicyReasonerVeritas final : public PolicyReasonerVeritasBase {
public:
    PolicyReasonerVeritas(
        const Model& model,
        const AddTreePolicy& policy,
        const vector<size_t>& var_order)
        : PolicyReasonerVeritasBase(model, policy, var_order)
    {
    }

    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t label) override;
};

class PolicyReasonerVeritasMasked final : public PolicyReasonerVeritasBase {
public:
    PolicyReasonerVeritasMasked(
        const Model& model,
        const AddTreePolicy& policy,
        const vector<size_t>& var_order)
        : PolicyReasonerVeritasBase(model, policy, var_order)
        , model_(&model)
    {
    }

    void prepare(const flat_state& state) override;

    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t label) override;

private:
    const Model* model_;
    ApplicabilityInformation infos_;
};

} // namespace police::ic3::syntactic
