#pragma once

#include "police/storage/flat_state.hpp"
#include "police/storage/variable_space.hpp"
#include "police/storage/vector.hpp"
#include "police/verifiers/ic3/cube.hpp"
#include "police/verifiers/ic3/syntactic/frames_storage.hpp"

#include <memory>

namespace police::ic3::syntactic {

class PolicyReasons {
public:
    PolicyReasons(const VariableSpace* variables, size_t num_labels);

    void block(Cube cube, size_t label);

    [[nodiscard]]
    bool is_blocked(const flat_state& state, size_t label) const;

    [[nodiscard]]
    bool is_blocked(const Cube& cube, size_t label) const;

    [[nodiscard]]
    vector<Cube> get_reasons(const flat_state& state, size_t label) const;

private:
    void drop_irrelevant_bounds(Cube& cube) const;

    vector<std::unique_ptr<FramesStorage>> per_label_;
    const VariableSpace* variables_;
};

} // namespace police::ic3::syntactic
