#include "police/verifiers/ic3/syntactic/start_avoid_checker.hpp"

namespace police::ic3::syntactic {

StartAvoidChecker::StartAvoidChecker(
    SMTFactory& smt_factory,
    const VariableSpace& variables,
    const VerificationProperty& property)
    : smt_(smt_factory.make_unique())
{
    smt_->add_variables(variables);
    smt_->add_constraint(property.avoid);
    smt_->add_constraint(property.start);
}

bool StartAvoidChecker::operator()() const
{
    auto result = smt_->solve();
    if (result == SMT::Status::SAT) {
        std::cout << "found an unsafe start state" << std::endl;
        auto model = smt_->get_model();
        std::cout << "[";
        for (size_t var = 0; var < model.size(); ++var) {
            std::cout << (var > 0 ? ", " : "") << model.get_value(var);
        }
        std::cout << "]" << std::endl;
        return true;
    }
    return false;
}

} // namespace police::ic3::syntactic
