#include "police/verifiers/sampling/sampler.hpp"

#include <ostream>

namespace police {

std::ostream& operator<<(std::ostream& out, const sampler::Statistics& stats)
{
    out << "Number of simulations: " << stats.total << "\n";
    out << "Satisfied avoid condition: " << stats.avoid << "\n";
    out << "Satisfied goal condition: " << stats.goal << "\n";
    out << "Simulations ended in terminal state: " << stats.terminal << "\n";
    out << "Exceeded length limit: " << stats.limit << "\n";
    out << "Average simulation length: "
        << (stats.total == 0
                ? -1.
                : (static_cast<double>(stats.length) / stats.total))
        << "\n";
    return out;
}

} // namespace police
