#pragma once

#include "police/verifiers/search/label_id.hpp"
#include "police/verifiers/search/node_id.hpp"

#include <concepts>
#include <utility>

namespace police::search {

template <typename P, typename StateType>
concept state_predicate = requires(P p) {
    { p(std::declval<StateType>()) } -> std::convertible_to<bool>;
};

template <typename F, typename StateType>
concept state_to_id_map = requires(F f) {
    { f(std::declval<StateType>()) } -> std::convertible_to<NodeId>;
};

template <typename F, typename StateType>
concept id_to_state_map = requires(F f) {
    { f(std::declval<NodeId>()) } -> std::convertible_to<StateType>;
};

template <typename R, typename StateType>
concept successor_range = requires(R r) {
    r.begin();
    r.end();
    { r.begin() != r.end() } -> std::convertible_to<bool>;
    { (*r.begin()).label } -> std::convertible_to<LabelId>;
    { (*r.begin()).state } -> std::convertible_to<StateType>;
};

template <typename G, typename StateType>
concept successor_generator = requires(G g) {
    { g(std::declval<StateType>()) } -> successor_range<StateType>;
};

template <typename F, typename StateType>
concept state_callable = requires(F f) { f(std::declval<StateType>()); };

} // namespace police::search
