#pragma once

#include "police/verifiers/search/concepts.hpp"
#include "police/verifiers/search/node_id.hpp"
#include "police/storage/segmented_vector.hpp"

namespace police::search {

template <typename StateType, search::state_to_id_map<StateType> StateToId>
struct FifoQueue {
    constexpr explicit FifoQueue(StateToId state_id_map = StateToId())
        : state_id_map_(std::move(state_id_map))
    {
    }

    constexpr bool push(const StateType& state)
    {
        queue_.push_back(state_id_map_(state));
        return true;
    }

    constexpr NodeId pop()
    {
        assert(!empty());
        NodeId result = queue_.front();
        queue_.pop_front();
        return result;
    }

    [[nodiscard]]
    constexpr bool empty() const
    {
        return queue_.empty();
    }

    void clear() { queue_.clear(); }

private:
    segmented_vector<NodeId> queue_;
    StateToId state_id_map_;
};

template <typename StateType, search::state_to_id_map<StateType> StateToId>
struct LifoQueue {
    constexpr explicit LifoQueue(StateToId state_id_map = StateToId())
        : state_id_map_(std::move(state_id_map))
    {
    }

    constexpr bool push(const StateType& state)
    {
        queue_.push_back(state_id_map_(state));
        return true;
    }

    constexpr NodeId pop()
    {
        assert(!empty());
        NodeId result = queue_.back();
        queue_.pop_front();
        return result;
    }

    [[nodiscard]]
    constexpr bool empty() const
    {
        return queue_.empty();
    }

    void clear() { queue_.clear(); }

private:
    segmented_vector<NodeId> queue_;
    StateToId state_id_map_;
};

} // namespace police::search
