#pragma once

#include "police/storage/state_registry.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/search/novelty_queue.hpp"

#include <cassert>
#include <iterator>

namespace police::search {

class StateFeatureRange;

class StateFeatureIterator {
public:
    using value_type = police::search::feature_vector_t;
    using difference_type = int;

    StateFeatureIterator() = default;
    explicit StateFeatureIterator(const vector<search::feature_t>* features);

    StateFeatureIterator& operator++();
    StateFeatureIterator operator++(int);

    [[nodiscard]]
    bool operator==(const StateFeatureIterator& other) const;

    [[nodiscard]]
    value_type operator*() const;

private:
    friend class StateFeatureRange;

    const vector<search::feature_t>* features_;
    vector<size_t> indices_{};
};

static_assert(std::forward_iterator<StateFeatureIterator>);

class StateFeatureRange {
public:
    StateFeatureRange(vector<search::feature_t> features, size_t max_width);

    [[nodiscard]]
    StateFeatureIterator begin() const;
    [[nodiscard]]
    const StateFeatureIterator& end() const;

private:
    vector<search::feature_t> features_;
    StateFeatureIterator end_;
};

static_assert(search::feature_range<StateFeatureRange>);

class StateNovelty {
public:
    StateNovelty(const VariableSpace& vspace, size_t max_width);

    [[nodiscard]]
    StateFeatureRange operator()(const CompressedState& state) const;

private:
    vector<std::pair<size_t, int_t>> vars_;
    size_t max_width_;
};

} // namespace police::search
