#pragma once

#include "police/linear_condition.hpp"
#include "police/relu_constraint.hpp"
#include "police/sat_model.hpp"

bool is_satisfied(
    const police::LinearConstraint& constraint,
    const police::SATModel& model);

bool is_satisfied(
    const police::ReluConstraint& constraint,
    const police::SATModel& model);

bool is_satisfied(
    const police::LinearConstraintDisjunction& constraint,
    const police::SATModel& model);

void check_constraint(
    const police::LinearConstraint& constraint,
    const police::SATModel& model);

void check_constraint(
    const police::ReluConstraint& constraint,
    const police::SATModel& model);

void check_constraint(
    const police::LinearConstraintDisjunction& constraint,
    const police::SATModel& model);

template <typename... Constraint>
void check_constraints(const police::SATModel& model, Constraint&&... constraint)
{
    (check_constraint(std::forward<Constraint>(constraint), model), ...);
}
