#pragma once

#include "police/marabou_preprocessor.hpp"
#include "police/nnlp_bnb.hpp"
#include "police/nnlp_lp.hpp"
#include "police/nnlp_marabou.hpp"
#include "police/nnlp_smt.hpp"
#include "police/lp_gurobi.hpp"
#include "police/smt_z3.hpp"

#include <memory>

inline police::NNLPSMT Z3_NNLP()
{
    return police::NNLPSMT(std::make_unique<police::Z3SMT>());
}

inline police::NNLPMarabouPreprocessor Z3_NNLP_Preprocessing()
{
    return police::NNLPMarabouPreprocessor(
        std::make_shared<police::NNLPSMT>(std::make_unique<police::Z3SMT>()));
}

inline police::NNLPLP Gurobi_NNLP()
{
    return police::NNLPLP(
        std::make_unique<police::GurobiLP>(police::LPOptimizationKind::MINIMIZE));
}

inline police::NNLPBranchNBound BnB_NNLP_Z3()
{
    return police::NNLPBranchNBound(std::make_unique<police::NNLPSMT>(Z3_NNLP()));
}

inline police::NNLPBranchNBound BnB_NNLP_Gurobi()
{
    return police::NNLPBranchNBound(
        std::make_unique<police::NNLPLP>(Gurobi_NNLP()));
}

inline police::NNLPBranchNBound BnB_NNLP_Marabou()
{
    return police::NNLPBranchNBound(std::make_unique<police::MarabouLP>());
}

inline police::NNLPMarabouPreprocessor Gurobi_NNLP_Preprocessing()
{
    return police::NNLPMarabouPreprocessor(
        std::make_shared<police::NNLPLP>(std::make_unique<police::GurobiLP>(
            police::LPOptimizationKind::MINIMIZE)));
}
