#pragma once

#include "police/linear_condition.hpp"
#include "police/model.hpp"
#include "police/storage/ffnn.hpp"
#include "police/successor_generator/successor_generator.hpp"
#include "police/verifiers/epic3/cube.hpp"

police::Model binary_flip_model(int bits);

police::LinearCondition binary_flip_initial_state(int bits);

police::LinearConstraintDisjunction binary_flip_negated_goal(int bits);

police::LinearCondition binary_flip_goal(int bits);

police::LinearCondition binary_flip_avoid(int bits);

struct BFlipSuccessorGenerator {
    police::vector<police::successor_generator::Successor>
    operator()(const police::FlatState& state) const;

    const police::FeedForwardNeuralNetwork<>* net;
    police::size_t bits;
    bool appfilter;
};

struct BFlipCheckGoal {
    bool operator()(const police::epic3::Cube& cube) const;
};

struct BFlipCheckAvoid {
    bool operator()(const police::epic3::Cube& cube) const;
};
