# Data Provenance for Image Auto-Regressive Generation

![Framework](wmar/assets/framework.png)

## Abstract

Image autoregressive models (IARs) have recently demonstrated remarkable capabilities in visual content generation, achieving photorealistic quality and rapid synthesis through the next-token prediction paradigm adapted from large language models. As these models become widely accessible, robust data provenance is required to reliably trace IAR-generated images to the source model that synthesized them. This is critical to prevent the spread of misinformation, detect fraud, and attribute harmful content. We find that although IAR-generated images often appear visually identical to real images, their generation process introduces characteristic patterns in their outputs, which serves as a reliable provenance signal for the generated images. Leveraging this, we present a post-hoc framework that enables the robust detection of such patterns for provenance tracing. Notably, our framework does not require modifications of the generative process or outputs. Thereby, it is applicable in contexts where prior watermarking methods cannot be used, such as for generated content that is already published without additional marks and for models that do not integrate watermarking.  We demonstrate the effectiveness of our approach across a wide range of IARs, highlighting its high potential for robust data provenance tracing in autoregressive image generation.

## Preparation

We provide code and additional README for every model in the corresponding folders. The scripts for RAR and Taming can be found in `wmar/`, VAR in `VAR/`, LlamaGen in `LlamaGen/`, VQDiffusion in `VQ-Diffusion/` and finally Infinity in `Infinity/`.

To analyze the provenance across all models, first prepare the natural image datasets `LAION-POP`, `MS-COCO` and `ImageNet-256`. Then continue to generate images using the different generative models following the descriptions in the respective folders. 




## Acknowledgement

We used code from the following repositories:
- [Watermark Autoregressive Image Generation](https://github.com/facebookresearch/wmar)
- [VAR](https://github.com/FoundationVision/VAR)
- [Infinity](https://github.com/FoundationVision/Infinity)
- [LlamaGen](https://github.com/FoundationVision/LlamaGen)
- [VQ-Diffusion](https://github.com/microsoft/VQ-Diffusion)
