# Data Provenance in IARS - VAR

##  Installation

###  Environment

Set up an environment as follows by installing the requirements.txt file.

If required, further instructions can be obtained from the [official VAR repository](https://github.com/FoundationVision/VAR).

## Files & Execution

Our main scripts can be found in ./generated.py, ./finetune_vqvae_with_dataset.py, ./image_detect_scale_optim_clean.py, ./image_detect_latent_tracer.py.

### Data Generation

Generating data and preparing for it for finetuning can be done by executing the following python file:

```bash
python ./generated.py
```

### Finetuning

For finetuning, ./scripts/run_finetune.sh
```bash
bash ./scripts/run_finetune.sh
```

### Data Provenance - Losses Calculation

For calculating our losses and baselines, execute scripts/run_loss_optim.sh:
```bash
bash ./scripts/run_loss_optim.sh
```

### Latenttracer Baseline 

To calculate results with latentteacer, execute tools/latenttracer.py:
```bash
bash ./run_loss_latenttracer.sh
```

### Setup Datasets
    
Please modify the given data paths in the python files.
```python
dataset_name_image_path = {
    "MS-COCO": "PATH_TO_MSCOCO_SUBSET", # TODO: =====> please specify the path to your MS-COCO subset <=====
    "VAR Generated": "PATH_TO_VAR_GENERATED_SUBSET", # TODO: =====> please specify the path to your VAR generated images subset <=====
    ...
}
```
