# Robust Overfitting may be mitigated by properly learned smoothening

#### Pretrained_models: (selected on validation set) 

[pretrained_models](https://www.dropbox.com/sh/1htrkwawfqh2hem/AAAOIz2A7ndA9VLyA6X_BXSta?dl=0)

1. cifar10_resnet18_std_SA_best.pt [checkpoint with best SA during standard training]
2. cifar10_resnet18_adv_RA_best.pt [checkpoint with best RA during adversarial training (AT)]
3. cifar10_resnet18_KDSWA_RA_best.pt [checkpoint with best RA during AT with KD&SWA]

**Standard Training:**

```
python -u main_std.py \
	--data ../data \ 
	--dataset cifar10 \
	--arch resnet18 \
	--save_dir std_cifar10_resnet18 
```

**PGD Adversarial Training:**

```
python -u main.py \
	--data ../data \ 
	--dataset cifar10 \
	--arch resnet18 \
	--save_dir AT_cifar10_resnet18 
```

**Adversarial Training with KD&SWA:**

```
python -u main.py \
	--data ../data \ 
	--dataset cifar10 \
	--arch resnet18 \
	--save_dir KDSWA_cifar10_resnet18 \
	--swa \
	--lwf \
	--t_weight1 pretrained_models/cifar10_resnet18_std_SA_best.pt \
	--t_weight2 pretrained_models/cifar10_resnet18_adv_RA_best.pt
```

**Testing under PGD-20 Linf eps=8/255** :

```
python -u test.py \
	--data ../data \
	--pretrained pretrained_models/**.pt 
```

