import numpy as np
import os
from edf import read_raw_edf


def read_isruc_path():
    data_path = []
    path_ = f""
    path_list = os.listdir(path_)
    for path in path_list:
        data_path.append(path_ + f"{path}/" + f"{path}")
    print(data_path)
    return list(data_path)


def save_raw_isruc():
    data_path = read_isruc_path()
    print("dataset length:", len(data_path))

    for i in range(len(data_path)):
        raw = read_raw_edf(data_path[i] + ".rec")
        print(raw.info)
        print(raw.info["ch_names"])
        folder = f""
        if not os.path.exists(folder):
            os.makedirs(folder)

        if "E1-M2" in raw.info["ch_names"]:
            raw = raw.pick_channels(['F3-M2', 'C3-M2', 'O1-M2', 'F4-M1', 'C4-M1', 'O2-M1'])
        else:
            raw = raw.pick_channels(['F3-A2', 'C3-A2', 'O1-A2', 'F4-A1', 'C4-A1', 'O2-A1'])

        raw_data = raw.get_data()
        print(raw_data.shape)
        save_data_path = folder + f"/{os.path.split(data_path[i])[1]}"
        np.save(save_data_path, raw_data)


if __name__ == '__main__':
    save_raw_isruc()
