# value_equal_transfer



## Setup

```
cd value_guided_data_filtering
conda create -n vgdf python=3.7
conda activate vgdf
pip install -r requirements.txt
```

##  Modify the source code of Gym
To load our xml file in **env/assets/**, we need to provide a variable for HalfCheetahEnv/Walker2dEnv/HumanoidEnv in the gym.

Go to **gym.envs.mujoco.${env(-v2)}**, and change the ${EnvClass}**.__init__()** from 

```
    def __init__(self):
```
to

```
    def __init__(self, xml_file="${half_cheetah/walker2d/humanoid}.xml"):
```


## Experiment/Hyperparameter setting

```
cd config/vgdf/
# Each yaml file corresponds to an environment.
```

## Launch experiments
  
**Launch experiments for single env**
```
cd script
# --seeds:        single or multiple random seeds. If multiple, we launch multiple experiments iteratively.
# --env:          chosen environment. IMPORTANT: this variable must align the yaml file name
# --exp_name:     you can annotate the experiment with some name, it is helpful to discriminate multiple experiments with different hyper-settings in the same environment

conda activate vgdf

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env hopper (--exp_name test)
```


**Launch experiments for online source domain experiments**
```
cd script
conda activate vgdf

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env halfcheetah

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env halfcheetah-morph

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env ant

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env ant-morph

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env walker

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env walker-morph

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env hopper

python train_vgdf.py --seeds 12 123 1234 12345 123456 --env hopper-morph 
```

**Launch experiments for offline source domain experiments**
```
cd script
conda activate vgdf

python train_vgdf_bc.py --seeds 12 123 1234 12345 123456 --env halfcheetah

python train_vgdf_bc.py --seeds 12 123 1234 12345 123456 --env halfcheetah-morph

python train_vgdf_bc.py --seeds 12 123 1234 12345 123456 --env walker

python train_vgdf_bc.py --seeds 12 123 1234 12345 123456 --env walker-morph

python train_vgdf_bc.py --seeds 12 123 1234 12345 123456 --env hopper

python train_vgdf_bc.py --seeds 12 123 1234 12345 123456 --env hopper-morph 
```