# Learning on Graphs with Missing Node Features

![](figures/feature_propagation_diagram.jpg)

## Dependencies

Our implementation works with python >= 3.9 and has the following dependencies:

```{bash}
numpy==1.20.2
ogb==1.3.1
pandas==1.3.0
torch==1.9.0
pyg==2.0.1
scikit-learn==0.23.2
```

## Usage
```{bash}
python run.py --dataset_name Computers --missing_rate 0.99
```
where *dataset_name* can be any of "Cora", "CiteSeer", "PubMed", "Photo", "Computers", "OGBN-Arxiv", "OGBN-Products" and "MixHopSynthetic".

## Baselines
GCNMF and PaGNN can be run as follows:
```{bash}
python run.py --model gcnmf --dataset_name Computers --missing_rate 0.99
python run.py --model pagnn --dataset_name Computers --missing_rate 0.99
```

The other baselines can be run by specifying the *filling_method* argument:
```{bash}
python run.py --filling_method zero --dataset_name Computers --missing_rate 0.99
python run.py --filling_method random --dataset_name Computers --missing_rate 0.99
python run.py --filling_method mean --dataset_name Computers --missing_rate 0.99
python run.py --filling_method neighborhood_mean --dataset_name Computers --missing_rate 0.99
```