<div align="center"> <h1>Gaming Envrionments</h1> </div> 

## Build Your Own Envrionments

### Gym and Retro Interface

#### Gymnasium Envrionments

**Overview**

Currently we support the following envrionments using gym:

- Sokoban
- Tetris
- 2048
- Candy Crush


**Step-by-Step Instructions**

1. Follow instructions from [Gymnasium](https://gymnasium.farama.org/introduction/create_custom_env/) to implement functions and methods for your own game.
2. Create a directory following the naming convention `custom_{index}_{game_name}`.
3. Implement `{GameName}Env.py` as a wrapper that (1) initialize and reset envrionments; (2) process action strings from agents and execute them in the environment; (3) generate new observations and output to agents (with images, rgb/ascii strings, textual descriptions and/or symbolic textual representations).
4. Implement `game_env_config.json` to pass:
   a. key env configuration arguments `env_init_kwargs`.
   b. `action_mapping` to map action strings generated by agents to executable action index.
   c. `render_mode`: either `human` for graphic display or like `rgb` or `ascii` strings.
   d. other key arguments to determine termination conditions or game settings.
5. Add your agent configuration to [configs](configs) so that a gaming agent can interface properly the envrionment.


##### Retro Envrionments

**Overview**

Gym [Retro](https://github.com/Farama-Foundation/stable-retro) is a library that enables classic video game emulation through a wide range of supported systems, providing a standardized interface via Gymnasium.

Currently we support the following envrionments using gym:
- Super Mario Bros 1985
- Ace Attorney: Phoenix Wright



**Step-by-Step Instructions (Add Existing games from Retro)**


1. You need to legally obtain the games files and import them with [this instruction](https://retro.readthedocs.io/en/latest/getting_started.html#importing-roms): `python3 -m retro.import /path/to/your/ROMs/directory/`.
2. Create a directory following the naming convention `retro_{index}_{game_name}`.
3. Implement `{GameName}Env.py` as a wrapper that (1) initialize and reset envrionments; (2) process action strings from agents and execute them in the environment; (3) generate new observations and output to agents (with images, rgb/ascii strings, textual descriptions and/or symbolic textual representations).
4. Implement `game_env_config.json` to pass:
   a. key env configuration arguments `env_init_kwargs`.
   b. `action_mapping` to map action strings generated by agents to executable action representation in Retro.
   c. `render_mode`/`render_mode_gym_adapter`: either `human` for graphic display or like `rgb` or `ascii` strings.
   d. other key arguments to determine termination conditions or game settings.
5. Add your agent configuration to [configs](configs) so that a gaming agent can interface properly the envrionment.

**Step-by-Step Instructions (Add new games to Retro)**

To integrate additional Retro environments that are not included in stable-retro, follow instructions in [Gym Retro](https://retro.readthedocs.io/en/latest/integration.html). For such games no `retro.import` is required. Check our ace_attorney implementation as an example.

### UI-only Interface

Coming Soon!
