import random
import numpy as np
from scipy.optimize import minimize
from scipy.optimize import Bounds
from scipy.optimize import LinearConstraint

def random_angle(seed):
    ''' Generate a random angle within [-90°, 90°], with probability density function p(x) = |4x/pi^2|, x \in [-pi/2, pi/2]
    '''
    random.seed(seed)
    S = random.uniform(0, 1)
    x = S ** (1/2) / 2 # p(x)=8x/pi^2, 0<x<pi; S(x)=4x^2/pi^2
    sign = random.randint(0,1)
    radius = x * (2*sign-1) # sign=0->-1; sign=1->1
    return radius * 180

epsilon = 1e-12

class WeightsSolver(object):
    def __init__(self, dimension, sum_bound, objective, constr):
        self.x0 = np.ones(dimension) * sum_bound / dimension
        self.bounds = Bounds(np.zeros(dimension), np.ones(dimension))
        if constr == 'relaxed':
            self.constraints = ()
        else:
            self.bounds = Bounds(np.zeros(dimension), np.ones(dimension))
            if constr == 'eq':
                self.constraints = LinearConstraint(np.ones([1,dimension]), np.array(sum_bound, dtype=np.float), np.array(sum_bound, dtype=np.float))
            elif constr == 'le':
                self.constraints = LinearConstraint(np.ones([1,dimension]), np.array(0.), np.array(sum_bound, dtype=np.float))
        self.objective = objective

    def solve(self):
        solution = minimize(self.objective, self.x0, method='SLSQP', tol=epsilon, bounds=self.bounds, constraints=self.constraints)
        return solution.x
        