import json
import os

def load_data_json(internal_path, external_path):
    
    internal_cid = []
    internal_train_data = {}
    internal_test_data = {}
    external_cid = []
    external_data = {}

    internal_files = os.listdir(internal_path)
    internal_files = [f for f in internal_files if f.endswith('.json')]
    for f in internal_files:
        file_path = os.path.join(internal_path, f)
        with open(file_path, 'r') as inf:
            int_data = json.load(inf)
        internal_cid.extend(int_data['cid'])
        internal_train_data.update(int_data['train_data'])
        internal_test_data.update(int_data['test_data'])

    external_files = os.listdir(external_path)
    external_files = [f for f in external_files if f.endswith('.json')]
    for f in external_files:
        file_path = os.path.join(external_path, f)
        with open(file_path, 'r') as inf:
            ext_data = json.load(inf)
        external_cid.extend(ext_data['cid'])
        external_data.update(ext_data['data'])

    return internal_cid, internal_train_data, internal_test_data, external_cid, external_data


def load_data_mnist(internal_path="/home/$HOME/DATA/MNIST/internal", external_path="/home/$HOME/DATA/MNIST/external"):
    return load_data_json(internal_path, external_path)


def load_data_fmnist(internal_path="/home/$HOME/DATA/Fashion-MNIST/internal", external_path="/home/$HOME/DATA/Fashion-MNIST/external"):
    return load_data_json(internal_path, external_path)


def load_data_emnist(internal_path="/home/$HOME/DATA/EMNIST/internal", external_path="/home/$HOME/DATA/EMNIST/external"):
    return load_data_json(internal_path, external_path)


def load_data_cifar10(internal_path="/home/$HOME/DATA/cifar10/internal", external_path="/home/$HOME/DATA/cifar10/external"):
    return load_data_json(internal_path, external_path)


def load_data_fets21(internal_path="/home/$HOME/DATA/Selfish-FeTS21/internal", external_path="/home/$HOME/DATA/Selfish-FeTS21/external"):
    return load_data_json(internal_path, external_path)


def load_data_shakespeare(internal_path="/home/$HOME/DATA/fed_shakespeare/selfish/internal", external_path="/home/$HOME/DATA/fed_shakespeare/selfish/external"):
    return load_data_json(internal_path, external_path)