export OPENAI_API_KEY=""
echo "Running ICLR moderation pipelines..."
echo "Make sure to adjust the paths and parameters as needed."
echo "Starting data preparation..."
python prepare_data_augmented.py \
  --therapy ../data/Sheet_1.csv \
  --resumes ../data/Sheet_2.csv \
  --aug-therapy ../data/10KSheet_1_augmented_v5_lenaware.csv \
  --aug-resumes ../data/10KSheet_2_augmented_v5_lenaware.csv \
  --test-size 0.10 \
  --seed 42 \
  --dedup-text

echo "Data preparation completed."
echo "Starting pipeline A with fairness considerations..."
# Pipeline A (winning config)
python pipeline_a_fair.py --train train_augmented.jsonl --embedding openai --label-exposure exposed --top-k 10 --chunk-size 768 --rebuild
echo "Pipeline A completed."
echo "Starting pipeline B with fairness considerations..."
# Pipeline B (winning config)
python pipeline_b_fair.py --train train_augmented.jsonl --label-exposure exposed --top-k 15 --llm-path /YOUR_PATH/models/llama3/Power-Llama-3-7B-Instruct.Q4_K_M.gguf
echo "Pipeline B completed."
echo "Evaluating fairness metrics..."
python evaluate_fair.py
echo "Fairness evaluation completed."

