"""
Description : Ceate pickle files of generated graphs and their distributions (degree,cycle,etc)
Last updated : AUTHOR AUTHOR 18.02.2020

Run example in command line:
| to get distributions from a list of networkx graphs in pkl format |
python graphs_from_lightning_models.py with filename=community_small dataset_pkl=True handle=dataset_to_pickle

python graphs_from_lightning_models.py with numb_of_bonds=1 model_dir="AttentionGAN/FOLDER_MODEL_RUN" numb_graphs=5000
    filename="FOLDER_MODEL_RUN" gen_state_dict="XXX-G.ckpt" z_dim=512

"""

from sacred import Experiment
import sys

from peagang.evaluation.statistics.utils.stat_tests import *
from utils.GSM_stats import *

# from peagang.evaluation.statistics.utils.helpers import *
from peagang.evaluation.statistics.utils.generate_lightning_g import graph_gen

import peagang.evaluation.plots.utils.plot_functions as plot_functions

from peagang.data.dense.QM9.MolGAN_QM9 import QM9preprocess

ex = Experiment("GraphsFromLightningModels")
from tqdm import tqdm


@ex.config
def config():
    """Configuration for graph generation from trained models"""
    # TODO build directory for node dist, computed from saved datasets

    # Model parameters
    z_dim = 512  # z dimension used in the run
    dataset = "QM9_5000"  # Dataset used in exp
    batch_size = 32  # Batch size used in the run
    generator_arch = "Refactor"  # Which code was used (this will be deprecated)
    node_dist = [
        0.0000,
        0.0000,
        0.0000,
        0.0000,
        0.0000,
        0.0000,
        0.0000,
        6.00720865e-04,
        9.99399279e-01,
    ]  # Node distribution of dataset

    # Graph generation file parameters
    numb_graphs = 5000  # Number of graphs to be generated by model

    model_epoch = None  # Epoch on which we evaluate model
    model_struct = None  # Name of model structure (Discriminator + Generator)

    # Relative paths
    exps_dir = "./peagang/experiments"
    version_exp = None  # Version from run (TestTubeLogger) | Usually version_0
    specific_exp = None  # Exp run filename

    graphs_dir = "./generated_graphs/"
    dist_dir = "./generated_graphs_dists/"
    dataset_dist_dir = "./generated_graphs_dataset_dists/"

    dataset_graphs_dir = "./datasets_graphs/"

    plots_save_dir = "./plots/"
    # AUTHORs mods
    device = "cpu"
    specific_epoch = None
    # BAD, but eh
    data_dir = "../../peagang/data/QM9/"


@ex.main
def main(_config, device, specific_epoch, data_dir):
    print(_config)
    for k, v in _config.items():
        if "dir" in k:
            os.makedirs(v, exist_ok=True)
    """
    generate distributions for the used dataset
    """
    sparsedataset = _config["dataset"] + ".sparsedataset"
    QM9data = QM9preprocess(data_dir, sparsedataset)
    QM9data.load(data_dir, sparsedataset)

    # model is not used here
    GfM = graph_gen(_config, checkpoint_path=None)
    GfM.dataset_to_dist(QM9data.Py_data)

    """
    Generates plots and graphs from last checkpoint
    """

    config_copy = _config.copy()
    for root, dirs, files in tqdm(os.walk(_config["exps_dir"]), desc="Exp"):
        """
        root=peagang/experiments/QQBla/version_0/checkpoints/
        files=epoch=N.ckpt
        """
        dir_list = root.split("/")

        if dir_list[-1] == "checkpoints":
            """
            does not handle vanilla TensorBoard versions (_vx suffix), okay for tensorboard
            """
            if len(files) == 0:
                continue

            version = dir_list[-2]
            specific_exp = dir_list[-3]
            print(specific_exp)

            epochs_ = []
            for file in tqdm(files, desc="File"):
                epoch_numb = file.split("=")[1].split(".")[0]
                # TODO: might want to add the version here
                epochs_.append(int(epoch_numb))

            if specific_epoch is not None:
                ckpt_name = "epoch=" + str(specific_epoch) + ".ckpt"
                print("setting specific_exp to", ckpt_name)
                config_copy["version_exp"] = version
                config_copy["model_epoch"] = ckpt_name
                config_copy["specific_exp"] = specific_exp + f"/epoch{specific_epoch}"
            else:
                last_epoch = max(epochs_)
                ckpt_name = "epoch=" + str(last_epoch) + ".ckpt"
                config_copy["version_exp"] = version
                config_copy["model_epoch"] = ckpt_name
                config_copy["specific_exp"] = specific_exp

            GfM = graph_gen(config_copy, checkpoint_path=os.path.join(root, ckpt_name))

            print(" ", config_copy["model_epoch"], "\n")
            GfM.analysis()
            loss_plot = plot_functions.plot_losses(config_copy)
            sample_plot = plot_functions.plot_molgrid(config_copy)
            degree_plot = plot_functions.plot_histogram(config_copy, metric="degree")
            cycle_plot = plot_functions.plot_histogram(config_copy, metric="cycles")

            plot_functions.one_img(
                [degree_plot, cycle_plot, loss_plot, sample_plot], config_copy
            )


def MMD_print(list_, ori_list_, pp_name, function):
    try:
        result_ = function(list_, ori_list_)
        print("Result {:.> 60}".format(result_))

    except Exception as error:
        print(
            "\n Did not compute MMD with function {} due to error: {} \n".format(
                pp_name, error
            )
        )


def check_necessary_input(_config):
    if _config["handle"] != "everything":
        if _config["specific_exp"] is None or _config["dataset"] is None:
            print(
                "########## ERROR ########## \n"
                "It is necessary to provide a specific_exp filename of the run as well as the dataset. \n"
                "Use the sacred format ex: 'python graphs_from_lightning_models.py with specific_exp=EXAMPLE' \n"
                "For further help: 'python graphs_from_lightning_models.py print_config'"
            )
            quit()


if __name__ == "__main__":
    ex.run_commandline(sys.argv)
