# ICLR 2021 Reviewer instructions


### Images/Tables plotting
MMD Table 1
1. Move to directory `code/peagang/`
2. Run `mmds_isomorphism.py` with the different configurations
3. Example run: `python evaluation/plots/mmds_isomorphism.py with GG-GAN_community20`
4. The code will run mmd statistics between training and test sets as well as calculating novelty scores.

Supplementary figures (showing graphs and batch wise diversity)

# Training and  Graphs with GANs

## GG-GAN
In order to train and generate graphs using our frameowork, follow the software install process below, then run the 
`code/peagang/experiment/GG_GAN.py` file. You can modify the hyperparameters using the standard sacred syntax and by default
the evaluation and graph generation should run directly after training.
Specifically, to train the models reported in the paper, you can run it with the named_configs
`mlprow_qm9, mlprow_commsmall20, mlprow_chordal9, attention_qm9, attention_chordal9` and attention_community.

# External models

To train the external baselines,run the "train.py" in the respective folder, to evaluate/sample refer to the appropriately titled python files.
We provide the sacred experiments with configs seed etc  and have wanted to also  include checkpoints/saved models used by us for reproducibility, but due to the size limit can not do, sorry.We hope the logs+ configs+seeds help.

# Collision demo

In order to replicate the plot from figure 2, run `code/peagang/experiments/collision_all.py` which should run the experiment and generat the plot for you.
To play with individual models, you can also directly run the sacred experiment `code/peagang/experiments/collsion.py`

# Benchmarks

To collect the the benchmark data, run the sacred experiments in

-  `code/peagang/experiments/GG_scalability.py`
-  `code/externals/benchmarks/CondGen/eval_scalability.py`
-  `code/externals/benchmarks/GraphRNN/eval_scalability.py`

After placing the sacred directories in a folder and adjusting the paths, the plot can then be generated with
`peagang/experiments/scale_plot.py`

#  Software setup (assuming you have a  more modern cluster than us)

1. Uncomment the `with open("requirements.txt") as f:` block which will overwrite the version lock and install the latest versions of things
2. Run `bash install_geometric.sh`
3. Run `pip install -e. `
4. Now, this should "just work"

## Key references for GNNs

- [The message passing framework](https://arxiv.org/abs/1704.01212)
- [How powerful are graph neural networks?](https://arxiv.org/abs/1810.00826)
- [What graph neural networks cannot learn](https://arxiv.org/abs/1907.03199)
- Graph generation papers [summary slides:](https://jian-tang.com/files/AAAI19/aaai-grltutorial-part3-generation.pdf):
  - [Graph VAE](https://arxiv.org/abs/1802.03480)
  - [Junction Tree Variational Autoencoder for Molecular Graph Generation](https://arxiv.org/abs/1802.04364)
  - [MolGAN: An implicit generative model for small molecular graphs](https://arxiv.org/abs/1805.11973)
  - [Graph Convolutional Policy Network for Goal-Directed Molecular Graph Generation](http://papers.nips.cc/paper/7877-graph-convolutional-policy-network-for-goal-directed-molecular-graph-generation)
