def logits_to_outputs(self, outputs):
    encoded = tokenizer(
        texts[start_idx : start_idx + batch_size],
        max_length=length,
        padding='max_length',
        truncation=True,
        return_tensors="pt",
    )
    input_ids = encoded["input_ids"].to(device)
    c_conditioning_mask = conditioning_mask.repeat(input_ids.size(0), 1).to(device)

    encoded = outputs.logits.argmax(-1)
    encoded_generation = encoded[~c_conditioning_mask]
    generated_texts_encoded = input_ids
    generated_texts_encoded[~c_conditioning_mask] = encoded_generation
    generated_texts_encoded = generated_texts_encoded.cpu()

    generations_accumulator += [
        tokenizer.decode(g) for g in generated_texts_encoded.tolist()
    ]
    assert len(
        [tokenizer.decode(g) for g in generated_texts_encoded.tolist()]
    ) == input_ids.size(0)
    print(f"Already generated {len(generations_accumulator)} sequences")
    encoded_accumulator += generated_texts_encoded.tolist()
    encoded_generations_accumulator += encoded_generation.view(
        input_ids.size(0), -1
    ).tolist()
    if start_idx == 0:
        input_ids[~c_conditioning_mask] = tokenizer.bos_token_id
        # for ex, gen in zip(input_ids[:10], generated_texts_encoded[:10]):
            # print(tokenizer.decode(ex))
            # print("-----")
            # print(tokenizer.decode(gen))
            # print("---------------------")
            
    assert len(generations_accumulator) == len(texts)
    if return_emb_norm:
        return (
            generations_accumulator,
            encoded_accumulator,
            encoded_generations_accumulator,
            norms,
        )
    outputs = (generations_accumulator, encoded_accumulator, encoded_generations_accumulator)
    if return_time_evaluation:
        outputs += (times, )
    return outputs, metrics