#!/bin/bash

for seed in {1..5}; do

# ACTIVE-I

python active_iql_jax.py \
--config_path configs/active_iql/antmaze_config.yaml \
--gym_id antmaze-umaze-v2 \
--temperature 3.0 \
--num_ensembles 5 \
--target_likelihood -5.25 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/antmaze_config.yaml \
--gym_id antmaze-umaze-diverse-v2 \
--target_likelihood -4.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/antmaze_config.yaml \
--gym_id antmaze-medium-play-v2 \
--target_likelihood -5.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/antmaze_config.yaml \
--gym_id antmaze-medium-diverse-v2 \
--num_ensembles 5 \
--target_likelihood -5.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/antmaze_config.yaml \
--gym_id antmaze-large-play-v2 \
--target_likelihood -5.25 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/antmaze_config.yaml \
--gym_id antmaze-large-diverse-v2 \
--target_likelihood -5.3 \
--seed $seed

# ACTIVE-S

python active_sql_jax.py \
--config_path configs/active_sql/antmaze_config.yaml \
--gym_id antmaze-umaze-v2 \
--target_likelihood -5.25 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/antmaze_config.yaml \
--gym_id antmaze-umaze-diverse-v2 \
--alpha 0.5 \
--num_ensembles 7 \
--target_likelihood -4.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/antmaze_config.yaml \
--gym_id antmaze-medium-play-v2 \
--alpha 0.01 \
--target_likelihood -5.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/antmaze_config.yaml \
--gym_id antmaze-medium-diverse-v2 \
--target_likelihood -5.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/antmaze_config.yaml \
--gym_id antmaze-large-play-v2 \
--target_likelihood -5.25 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/antmaze_config.yaml \
--gym_id antmaze-large-diverse-v2 \
--alpha 0.01 \
--target_likelihood -5.3 \
--seed $seed

done