#!/bin/bash

for seed in {1..5}; do

# ACTIVE-I

python ive_iql_jax.py \
--config_path configs/active_iql/kitchen_config.yaml \
--gym_id kitchen-complete-v0 \
--expectile 0.97 \
--temperature 0.3 \
--seed $seed

python ive_iql_jax.py \
--config_path configs/active_iql/kitchen_config.yaml \
--gym_id kitchen-partial-v0 \
--expectile 0.9 \
--seed $seed

python ive_iql_jax.py \
--config_path configs/active_iql/kitchen_config.yaml \
--gym_id kitchen-mixed-v0 \
--expectile 0.95 \
--temperature 0.3 \
--seed $seed

# ACTIVE-S

python ive_sql_jax.py \
--config_path configs/active_sql/kitchen_config.yaml \
--gym_id kitchen-complete-v0 \
--alpha 0.05 \
--seed $seed

python ive_sql_jax.py \
--config_path configs/active_sql/kitchen_config.yaml \
--gym_id kitchen-partial-v0 \
--alpha 0.3 \
--seed $seed

python ive_sql_jax.py \
--config_path configs/active_sql/kitchen_config.yaml \
--gym_id kitchen-mixed-v0 \
--alpha 0.1 \
--num_ensembles 7 \
--seed $seed

done