#!/bin/bash

for seed in {1..5}; do

# ACTIVE-I

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id halfcheetah-medium-v2 \
--expectile 0.9 \
--quantile 1.0 \
--target_likelihood 1.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id hopper-medium-v2 \
--expectile 0.9 \
--quantile 1.0 \
--target_likelihood 0.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id walker2d-medium-v2 \
--expectile 0.9 \
--quantile 1.0 \
--target_likelihood 1.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id halfcheetah-medium-replay-v2 \
--expectile 0.9 \
--quantile 1.0 \
--target_likelihood -11.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id hopper-medium-replay-v2 \
--expectile 0.9 \
--quantile 1.0 \
--target_likelihood -5.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id walker2d-medium-replay-v2 \
--expectile 0.9 \
--quantile 1.0 \
--target_likelihood -7.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id halfcheetah-medium-expert-v2 \
--target_likelihood 1.75 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id hopper-medium-expert-v2 \
--target_likelihood 0.0 \
--seed $seed

python active_iql_jax.py \
--config_path configs/active_iql/mujoco_config.yaml \
--gym_id walker2d-medium-expert-v2 \
--target_likelihood 1.75 \
--seed $seed

# ACTIVE-S

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id halfcheetah-medium-v2 \
--alpha 0.03 \
--quantile 1.0 \
--target_likelihood -1.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id hopper-medium-v2 \
--alpha 0.1 \
--quantile 1.0 \
--target_likelihood -0.9 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id walker2d-medium-v2 \
--alpha 0.1 \
--quantile 1.0 \
--target_likelihood 0.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id halfcheetah-medium-replay-v2 \
--alpha 0.1 \
--quantile 1.0 \
--target_likelihood -11.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id hopper-medium-replay-v2 \
--alpha 0.1 \
--quantile 1.0 \
--target_likelihood -5.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id walker2d-medium-replay-v2 \
--quantile_boot 0.5 \
--target_likelihood -3.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id halfcheetah-medium-expert-v2 \
--target_likelihood 1.75 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id hopper-medium-expert-v2 \
--target_likelihood 0.0 \
--seed $seed

python active_sql_jax.py \
--config_path configs/active_sql/mujoco_config.yaml \
--gym_id walker2d-medium-expert-v2 \
--target_likelihood 1.75 \
--seed $seed

done