import random as r
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX
seed=2024
r.seed(seed)

# capitalize_correct_answer
capitalize_correct_answer_schema = [
    {
	"instruction_id": "capitalize_correct_answer",
	"instruction_text": ["answer the question by printing the text associated with the correct option label in uppercase. Do not print the option label.", "capitalize the text associated with the optional label that answers the question correctly. Do not print the option label."],
	"operation": [" CAPITALIZE "],
	"python_function_name": "capitalize_correct_answer",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    },
]

def capitalize_correct_answer(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"
    input_instance["instruction_id"] = capitalize_correct_answer_schema[0]["instruction_id"]
    new_instruction = capitalize_correct_answer_schema[0]["instruction_text"][r.randint(0,len(capitalize_correct_answer_schema[0]["instruction_text"])-1)]
    
    # we add capitalizing correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX
    input_instance['instruction_output'].append(input_instance["ground_truth_answer_text"].upper())
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance["candidate_answer_label_space"]
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]
    candidate_outputs_after_instruction = []
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate_label.upper())
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate_label.lower())
        if candidate != input_instance["ground_truth_answer_text"]:
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate.lower())
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate.upper())
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label.upper())
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label.lower())
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
            if all(x.isalpha() or x.isspace() for x in candidate.strip()) and len(candidate)>1:
                input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate.lower())

        else:
             if all(x.isalpha() or x.isspace() for x in candidate.strip()) and len(candidate)>1:
                input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate.lower())
    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.STRING_MANIPULATION
    return input_instance
